//=============================================================================

/*:
 * @plugindesc ヘルプウィンドウにテキストを表示するタイミングを増やします。
 * 
 * @author LefTonbo
 *
 * @param =SceneEquip=
 * @default
 *
 * @param HelpEquip Equip
 * @parent =SceneEquip=
 * @desc 装備シーン - 「装備」ヘルプウィンドウ表示文字列
 * @default 装備を変更します
 *
 * @param HelpEquip Optimize
 * @parent =SceneEquip=
 * @desc 装備シーン - 「最強装備」ヘルプウィンドウ表示文字列
 * @default 上昇能力値が最も大きい装備を自動選択して装備します
 *
 * @param HelpEquip Clear
 * @parent =SceneEquip=
 * @desc 装備シーン - 「全て外す」ヘルプウィンドウ表示文字列
 * @default 装備を全て外します
 *
 * @param HelpEquip Cancel
 * @parent =SceneEquip=
 * @desc 装備シーン - 「完了」ヘルプウィンドウ表示文字列
 * @default 装備ウィンドウを閉じてメインメニューに戻ります
 *
 */

//=============================================================================

var Imported = Imported || {};
Imported.LP_MoreHelpText = true;

var LeftPlugin = LeftPlugin || {};

LeftPlugin.Parameters = PluginManager.parameters('LP_MoreHelpText');
LeftPlugin.Param = LeftPlugin.Param || {};

LeftPlugin.Param.HelpEquip_Equip = String(LeftPlugin.Parameters['HelpEquip Equip']).replace(/\\n/g, '\n');
LeftPlugin.Param.HelpEquip_Optimize = String(LeftPlugin.Parameters['HelpEquip Optimize']).replace(/\\n/g, '\n');
LeftPlugin.Param.HelpEquip_Clear = String(LeftPlugin.Parameters['HelpEquip Clear']).replace(/\\n/g, '\n');
LeftPlugin.Param.HelpEquip_Cancel = String(LeftPlugin.Parameters['HelpEquip Cancel']).replace(/\\n/g, '\n');

//=============================================================================

(function() {

//=============================================================================
// Window_EquipCommand
//=============================================================================

Window_EquipCommand.prototype.updateHelp = function() {
  Window_Selectable.prototype.updateHelp.call(this);
  switch (this.currentSymbol()) {
    case 'equip':
      this._helpWindow.setText(LeftPlugin.Param.HelpEquip_Equip);
      break;
    case 'optimize':
      this._helpWindow.setText(LeftPlugin.Param.HelpEquip_Optimize);
      break;
    case 'clear':
      this._helpWindow.setText(LeftPlugin.Param.HelpEquip_Clear);
      break;
    case 'cancel':
      this._helpWindow.setText(LeftPlugin.Param.HelpEquip_Cancel);
      break;
    default:
      break;
  }
};

//=============================================================================

})();

// EOF
